
;--------------------------------------------------------------------
;Reads in the Haaart & Madau (2012, ApJ, 746, 125) UV background table
;and interpolates to obtain the HI photo-ionisation rate at the
;redshift of the spectra.
;--------------------------------------------------------------------

file_uvb = './TREECOOL_HM12_G+Q'

openr,2,file_uvb

redshift = dblarr(100)
gH0      = dblarr(100)   

count = 0   
while (not EOF(2)) do begin
   readf,2,in1,in2
   redshift(count) = 10.0^in1 - 1.0d
   gH0(count)  = in2   
   count = count+1
endwhile
close,2

redshift = redshift[0:count-1]
gH0  = gH0[0:count-1]

gH0z = interpol(gH0,redshift,ztime)

print,'The H1 photo-ionisation rate is ',strcompress(float(gH0z),/remove_all),' s^-1'

