
;--------------------------------------------------------------------
;Converts the pixel positions for each sight-line into observed
;frame wavelength.
;--------------------------------------------------------------------

;; Hubble parameter [km s^-1 Mpc^-1]
Hz = 100.0 * hubble*sqrt(omegaM*(1.0 + ztime)^3.0 + omegaL)

;; Pixel scale [pMpc]
pixels_pMpc = 1.0d-3*pixels/(hubble * (1.0 + ztime))

;; Hubble velocity [km s^-1]
vel = Hz * pixels_pMpc

;; Wavelength [Angstroms]
lambda_Lya_rest = 1215.6701 ; Ly-a rest-frame wavelength [Angstroms]
ckms = 2.9979d5 ; Speed of light [km s^-1]
wvel = vel/ckms
lambda = lambda_lya_rest*(1.0 + ztime)*sqrt((1.0 + wvel)/(1.0 - wvel))
